﻿
Partial Class aswap
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    'var to store the swap number of the current swap
    'if this is set to -1 then it indicates a new swap
    'if it is set to >=0 then it indicates a swap for editing
    Dim SwapNo As Integer

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        'this event runs when the save button is pressed
        '
        'var to store the name of the image file
        Dim ImageFile As String
        'var to store the swap description
        Dim SwapDescription As String
        'var to store the swap title
        Dim SwapTitle As String
        'var to store the error message
        Dim ErrorMsg As String
        'get the image file
        ImageFile = txtPictureFile.Text
        'get the swap description
        SwapDescription = txtDescription.Text
        'get the swap title
        SwapTitle = txtTitle.Text
        'validate the form getting any error messages
        ErrorMsg = SwapValid()
        'if there are no errors
        If ErrorMsg = "" Then
            'if the current swap = -1 this is a new record
            If SwapNo = NO_ITEM Then
                'call the add swap sub procedure
                Call AddSwap(SwapTitle, SwapDescription, ImageFile)
            Else
                'else we have been editing an existing record
                Call UpdateSwap(SwapTitle, SwapDescription, ImageFile)
            End If
            'redirect to the swap manager
            Response.Redirect("swapmanager.aspx")
        Else
            'display any error messages
            lblError.Text = ErrorMsg
        End If
    End Sub

    Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'redirect to the swap manager page
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'this event runs when the page is loaded
        '
        'check that the current user is logged in correctly
        Call CheckLogin()
        'get the swap number from the session object
        SwapNo = Session("SwapNo")
        'if this is the first time the page has loaded
        If IsPostBack = False Then
            'if the swap number is not -1 we need to edit an existing swap
            If SwapNo <> NO_ITEM Then
                'load the details for this swap
                Call LoadSwap()
            End If
        End If
    End Sub

    Protected Sub btnSet_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSet.Click
        'this event runs when a picture file is uploaded
        'upload the file
        Call Upload("#PN")
    End Sub

    Function SwapValid() As String
        'this function validates the swap form
        'it returns an error message if there are problems as a string
        '
        'var to store the error message
        Dim ErrMsg As String
        'set the error message to blank
        ErrMsg = ""
        'if there is no title
        If txtTitle.Text = "" Then
            'set the error message
            ErrMsg = ErrMsg & " you must specify a title "
        End If
        'if there is no description
        If txtDescription.Text = "" Then
            'set the error message
            ErrMsg = ErrMsg & " you must write a description "
        End If
        'if there is no image
        If txtPictureFile.Text = "" Then
            'set the error message
            ErrMsg = ErrMsg & " you need to upload an image "
        End If
        Return ErrMsg
    End Function

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub

    Sub Upload(ByVal PNo As String)
        'this sub uploads an image file to the site 
        'it accepts one parameter (the pnumber) which is only used on the trading floor
        '
        'var to store the file name
        Dim FileName As String
        'var to store the file path
        Dim FilePath As String
        'var to store the path of the app on the server
        Dim BaseDir As String = System.AppDomain.CurrentDomain.BaseDirectory()
        'clear the error label
        lblError.Text = ""
        'if a file has been selected
        If fupPicture.HasFile = True Then
            'get the file name
            FileName = fupPicture.FileName
            'if the file is of the correct type
            If CorrectType(FileName) Then
                'if no p number has been specified
                If PNo = "#PN" Then
                    'just upload the picture
                    FilePath = BaseDir & "\" & FileName
                Else
                    'if a p number has been specified then use the p number as a folder
                    FilePath = BaseDir & "\" & PNo & "\" & FileName
                End If
                'save the file to the server
                fupPicture.SaveAs(FilePath)
                'set the file name of the record to this file
                txtPictureFile.Text = FileName
                'display the image file
                imgSwap.ImageUrl = FileName
            Else
                'state that this is not ana allowed file type
                lblError.Text = "That is not an allowed file type."
            End If
        Else
            'state that no file has been selected
            lblError.Text = "You must select a file to upload."
        End If
    End Sub

    Private Function CorrectType(ByVal FileName As String) As Boolean
        'this function checks a file for upload to make sure it is of an allowed type
        'var to store the extension of the file
        Dim Ext As String = System.IO.Path.GetExtension(FileName)
        'check the file extension
        Select Case Ext.ToLower
            'if a jpg
            Case ".jpg"
                Return True
                'if a jpeg
            Case ".jpeg"
                Return True
                'if a gif
            Case ".gif"
                Return True
                'if a png
            Case ".png"
                Return True
            Case Else 'otherwise return false
                Return False
        End Select
    End Function

    Sub AddSwap(ByVal SwapTitle As String, ByVal SwapDescription As String, ByVal ImageFile As String)
        'this sub adds a new swap to the swap table
        '
        'open a connection to the swap table
        Dim Swaps As New DatabaseTable("dvd.mdb", "select * from swap", "#PN", "#PW")
        'set the title
        Swaps.NewRecord.Item("Title") = SwapTitle
        'set the description
        Swaps.NewRecord.Item("Description") = SwapDescription
        'set the name of the image file
        Swaps.NewRecord.Item("ImageFile") = ImageFile
        'add the record
        Swaps.AddNewRecord()
        'save the changes
        Swaps.SaveChanges()
    End Sub

    '############
    'edit swap code

    Sub LoadSwap()
        'this sub loads an existing swap to the page
        '
        'open a connection to the table finding this swap record
        Dim ASwap As New DatabaseTable("dvd.mdb", "select * from swap where SwapNo = " & SwapNo, "#PN", "#PW")
        'if the record is found
        If ASwap.Count = 1 Then
            'get the swap title
            txtTitle.Text = ASwap.RecordNumber(0).Item("Title")
            'get the swap description
            txtDescription.Text = ASwap.RecordNumber(0).Item("Description")
            'get the image file
            txtPictureFile.Text = ASwap.RecordNumber(0).Item("ImageFile")
            'set the picture 
            imgSwap.ImageUrl = ASwap.RecordNumber(0).Item("ImageFile")
        End If
    End Sub

    Sub UpdateSwap(ByVal SwapTitle As String, ByVal SwapDescription As String, ByVal ImageFile As String)
        'this sub adds a new swap to the swap table
        '
        'open a connection to the swap table
        Dim Swaps As New DatabaseTable("dvd.mdb", "select * from swap where swapno=" & SwapNo, "#PN", "#PW")
        If Swaps.Count = 1 Then
            'set the title
            Swaps.RecordNumber(0).Item("Title") = SwapTitle
            'set the description
            Swaps.RecordNumber(0).Item("Description") = SwapDescription
            'set the name of the image file
            Swaps.RecordNumber(0).Item("ImageFile") = ImageFile
            'save the changes
            Swaps.SaveChanges()
        End If
    End Sub
End Class
